/** @file   electricfence.h
 * @brief   Declaration of ElectricFence - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:41 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_ELECTRICFENCE_H
#define H_WWW_ELECTRICFENCE_H

#include "eng2d.h"


namespace WeWantWar {

/** @class  ElectricFence
 * @brief   Represents an electric sparks that is created between two coordinates.
 * @author  Tomi Lamminsaari
 *
 */
class ElectricFence : public eng2d::LightFence
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  /** The magnitude of the shock-force that hits the player when he touches
   * the ElectricFence.
   */
  static float s_shockMagnitude;
  /** How much damage the touch causes. */
  static int s_shockDamage;
  
  /** The Type id of Electric fences. Returned from @c fenceType() - method */
  static const int FENCETYPE_ELECTRIC = 1;

  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	ElectricFence( const eng2d::Vec2D& rBeg, const eng2d::Vec2D& rEnd );


	/** Destructor
   */
	virtual ~ElectricFence();

private:

	/** Copy constructor.
   * @param     rO                Reference to another ElectricFence
   */
  ElectricFence( const ElectricFence& rO );

	/** Assignment operator
   * @param     rO                Reference to another ElectricFence
   * @return    Reference to us.
   */
  ElectricFence& operator = ( const ElectricFence& rO );

public:


  ///
  /// Methods
  /// =======



  ///
  /// Getter methods
  /// ==============

  /** Returns the type of this fence
   * @return    ElectricFence::FENCETYPE_ELECTRIC
   */
  virtual int fenceType() const;


  ///
  /// Members
  /// =======




private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: electricfence.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:54+02  lamminsa
 * Initial revision
 *
 */
 
